#ifndef __LINUX_HY46XX_TS_H__
#define __LINUX_HY46XX_TS_H__

//RST GPIO Setting
#define HY46XX_RESET_PIN	234//PH10
#define HY46XX_RESET_PIN_NAME	"hy46xx-reset"
#define HY46XX_IRQ_PIN		359//PL7
/************************************************************/
//#define HY46XX_FW_UPDATE_ENABLE
//#define LINUX_OS
//#define IIC_BUFF_CHECK_ENABLE
 
/************************************************************/
#define HY46XX_NAME	"hy46xx_ts"
//#define IIC_BUFF_CHECK_ENABLE
#define CFG_MAX_TOUCH_POINTS	5
#define RESOLUTION_X			1280
#define RESOLUTION_Y			600

#define HY_PRESS				0x08
#define HY_MAX_ID				0x0F
#define HY_TOUCH_STEP			6
#define HY_TOUCH_X_H_POS		3
#define HY_TOUCH_X_L_POS		4
#define HY_TOUCH_Y_H_POS		5
#define HY_TOUCH_Y_L_POS		6
#define HY_TOUCH_EVENT_POS		3
#define HY_TOUCH_ID_POS			5

#define POINT_READ_BUF			(3 + HY_TOUCH_STEP * CFG_MAX_TOUCH_POINTS)

#define HY46XX_REG_FW_VER		0xA6
#define HY46XX_REG_SLEEP_MODE	0xA5

#ifdef HY46XX_FW_UPDATE_ENABLE
#define    HYS_PACKET_LENGTH          128
static unsigned char CTPM_FW[]=
{
	#include "hycon_update_fw.i"
};  
#endif
#ifdef HYS_APK_DEBUG//HY46XX_FW_URDATE_WITH_BIN_FILE
#define PROC_UPGRADE				0
#define PROC_READ_REGISTER			1
#define PROC_WRITE_REGISTER			2
#define PROC_AUTOCLB				4

#define PROC_NAME	"hy46xx-debug"
static unsigned char proc_operate_mode = PROC_UPGRADE;
static struct proc_dir_entry *hy46xx_proc_entry;

#endif
/************************************************************/
struct hy46xx_platform_data {
	unsigned int x_max;
	unsigned int y_max;
	unsigned long irqflags;	/*default:IRQF_TRIGGER_FALLING*/
	unsigned int irq;
	unsigned int reset;
};

struct ts_event {
	unsigned short au16_x[CFG_MAX_TOUCH_POINTS];	/*x coordinate */
	unsigned short au16_y[CFG_MAX_TOUCH_POINTS];	/*y coordinate */
	unsigned char au8_touch_event[CFG_MAX_TOUCH_POINTS];	/*touch event:
					0 -- down; 1-- contact; 2 -- contact */
	unsigned char au8_finger_id[CFG_MAX_TOUCH_POINTS];	/*touch ID */
	unsigned short pressure;
	unsigned char touch_point;
};
struct hy46xx_ts_data {
	unsigned int irq;
	unsigned int x_max;
	unsigned int y_max;
	struct i2c_client *client;
	struct input_dev *input_dev;
	struct ts_event event;
	struct hy46xx_platform_data *pdata;
	#ifdef CONFIG_PM
	struct early_suspend *early_suspend;
	#endif
};

#endif
