#!/bin/sh
#Get EETI Debug information script. Version 1.0A (20201123)
INFO_PATH="./eeti/info.html"
DMESG_PATH="./eeti/dmesg"
INFO_FOLDER="./eeti/"
CONFIG_FILE="/data/eGalax/eGTouchA.ini"
DRIVER_LOG="eGTouchA.log"

CheckPermission() {
    echo -n "(I) Check user permission:"
    account=`whoami`
    if [ ${account} = "root" ]; then
        echo " ${account}, you are the supervisor."
    else
        echo " ${account}, you are NOT the supervisor."
        echo "(E) The root permission is required to run this installer."
        echo ""
        exit 1
    fi
}

CheckPermission
echo "Start to collect log..."

#Modify DebugBits

DEBUG_BITS="FFFFF"
sed -i '2d' $CONFIG_FILE
sed -i '1a DebugEnableBits\t\t\t'`echo $DEBUG_BITS` $CONFIG_FILE

#Restart driver
eGTouchD -f
sleep 7

#Create folder to put information
cd /data/eGalax/
mkdir $INFO_FOLDER
touch $INFO_PATH
chmod 666 $INFO_PATH

#Print Information to file
#getprop ro.build.version.release
#getprop ro.build.version.sdk 
{
echo "<html>"
echo "<body>"
echo "<tr>"
echo "<h1><strong><th>EETI Debug Log</th></strong></h1>"
echo "</tr>"
echo "<tr>"
date
echo "<p><strong><th>=====CPU Info.=====</th></strong></p>"
cat /proc/cpuinfo | grep 'model name'
echo "<br>"
getprop ro.arch
echo "<br>"
getprop ro.build.product
echo "<br>"
getprop ro.product.device
echo "<br>"
echo "</tr>"
echo "<tr>"
echo "<p><strong><th>=====Kernel version.=====</th></strong></p>"
cat /proc/version
echo "</tr>"
echo "<tr>"
echo "<p><strong><th>=====Android version.=====</th></strong></p>"
getprop ro.build.version.release
echo "</tr>"
echo "<tr>"
echo "<p><strong><th>=====SDK version=====</th></strong></p>"
getprop ro.build.version.sdk 
echo "</tr>"
echo "<tr>"
echo "<p><strong><th>=====Input Devices=====</th></strong></p>"
cat /proc/bus/input/devices
echo "</tr>"
echo "</body>"
echo "</html>"
}>  $INFO_PATH

#Copy dmesg
dmesg >> "$DMESG_PATH"

#Copy driver log
logcat -d | grep TouchD >> $INFO_FOLDER$DRIVER_LOG

#Recover DebugBits
DEBUG_BITS="1"
sed -i '2d' $CONFIG_FILE
sed -i '1a DebugEnableBits\t\t\t'`echo $DEBUG_BITS` $CONFIG_FILE

#Copy config file
cp $CONFIG_FILE $INFO_FOLDER

#Restart driver
eGTouchD -f

tar -zcvf ./eeti.tar.gz $INFO_FOLDER > /dev/null
rm -rf $INFO_FOLDER

echo "Finish."
