#ifndef __LINUX_HY46XX_TS_H__
#define __LINUX_HY46XX_TS_H__

#ifdef CONFIG_HAS_EARLYSUSPEND
#include <linux/earlysuspend.h>
#endif

#include "tpd.h"

//#define HY46XX_FW_UPDATE_ENABLE
//#define LINUX_OS
//#define IIC_BUFF_CHECK_ENABLE
/*****************************************************************************
 * DEFINE
 *****************************************************************************/
#define HY46XX_MAX_POINT_NUM   			5
#define HY46XX_FINGER_POS				6
#define HY46XX_MAX_TOUCH_ID				0x0A
#define HY46XX_SLAVE_ADDR				0x70

#define    HYS_PACKET_LENGTH        	128
/*****************************************************************************
 * REG
 *****************************************************************************/
#define HY46XX_MODE_REG					0x00
#define HY46XX_POWER_REG				0xA5
#define HY46XX_FIRMWARE_REG	  			0xA6
#define HY46XX_GESTURE_REG				0x01
#define HY46XX_FINGER_NUMBER_REG	  	0x02
#define HY46XX_BASE_TOUCHID_REG			0x05
#define HY46XX_BASE_X_MSB_REG			0x03
#define HY46XX_BASE_EVENT_REG       	0x03
#define HY46XX_BASE_X_LSB_REG			0x04
#define HY46XX_BASE_Y_MSB_REG			0x05
#define HY46XX_BASE_Y_LSB_REG			0x06

enum exp_fn {
	RMI_FW_UPDATER = 0,
};

struct hy46xx_data{
  struct input_dev *input_dev;
	struct i2c_client *i2c_client;

	struct mutex hy46xx_io_ctrl_mutex;

	struct workqueue_struct *fwu_workqueue;
	struct delayed_work fwu_work;
	
	bool touch_stopped;
	unsigned char num_of_fingers;
	
#ifdef CONFIG_HAS_EARLYSUSPEND
	struct early_suspend early_suspend;
#endif		
	
	void (*reset_device)(int level);
	int  (*iqr_enable)(bool enable);
	int  (*i2c_read)(unsigned short addr, unsigned char *data, unsigned short length);
	int  (*i2c_write)(unsigned char *data, unsigned short length);
};

struct hy46xx_exp_fn {
	enum exp_fn fn_type;
	int (*init)(struct hy46xx_data *_data);
	void (*remove)(struct hy46xx_data *_data);
	void (*reset)(struct hy46xx_data *_data);
	void (*reinit)(struct hy46xx_data *_data);
	void (*early_suspend)(struct hy46xx_data *_data);
	void (*suspend)(struct hy46xx_data *_data);
	void (*resume)(struct hy46xx_data *_data);
	void (*late_resume)(struct hy46xx_data *_data);
	void (*attn)(struct hy46xx_data *_data,
			unsigned char intr_mask);
};

struct hy46xx_exp_fhandler {
	struct hy46xx_exp_fn *exp_fn;
	bool insert;
	bool remove;
	struct list_head link;
};

struct hy46xx_exp_fn_data {
	bool initialized;
	bool queue_work;
	struct mutex mutex;
	struct list_head list;
	struct delayed_work work;
	struct workqueue_struct *workqueue;
	struct hy46xx_data *_data;
};

void hy46xx_new_function(struct hy46xx_exp_fn *exp_fn,
		bool insert);


#endif