/* drivers/input/touchscreen/hy46xx_ts.c
 *
 * HYCON hy46xx TouchScreen driver.
 *
 * Copyright (c) 2010  Hycon tech Ltd.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/cdev.h>
#include <linux/device.h>
#include <linux/delay.h>
//#include <linux/earlysuspend.h>
#include <linux/fs.h>
#include <linux/i2c.h>
#include <linux/input.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/input/mt.h>
#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/kthread.h>
#include <linux/mutex.h>
#include <linux/module.h>
#include <linux/mount.h>
#include <linux/netdevice.h>
#include <linux/proc_fs.h>
#include <linux/string.h>
#include <linux/slab.h>
#include <linux/semaphore.h>
#include <linux/syscalls.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/types.h>
#include <linux/unistd.h>
#include <linux/uaccess.h>
#include <asm/uaccess.h>
#include <asm/unistd.h>

#include <linux/gpio.h>
//#include <mach/irqs.h>
//#include <mach/gpio.h>
//#include <mach/map.h>
//#include <mach/regs-clock.h>
//#include <mach/regs-gpio.h>
//#include <plat/gpio-cfg.h>

#include "hy46xx_ts.h"

#define hy46xx_ts_suspend	NULL
#define hy46xx_ts_resume	NULL

//static struct i2c_client *this_client;
//static struct mutex g_device_mutex;

/************************************************************/

static int i2c_interface_recv(struct i2c_client* client, unsigned char* pbt_buf, int dw_lenth)
{
    int ret;    
    ret=i2c_master_recv(client, pbt_buf, dw_lenth);
    if(ret<=0)
    {
        return 0;
    }  
    return ret;
}
/************************************************************/
static int i2c_interface_send(struct i2c_client* client, unsigned char* pbt_buf, int dw_lenth)
{
    int ret;
    ret=i2c_master_send(client, pbt_buf, dw_lenth);
    if(ret<0)
    {
        return 0;
    }
    return ret;
}

/**************************************************************/				
int hy46xx_i2c_Read(struct i2c_client *client, unsigned char *writebuf, int writelen, unsigned char *readbuf, int readlen)
{
	int ret;

	if (writelen > 0) {
		struct i2c_msg msgs[] = {
			{
			 .addr = client->addr,
			 .flags = 0,
			 .len = writelen,
			 .buf = writebuf,
			 },
			{
			 .addr = client->addr,
			 .flags = 1,
			 .len = readlen,
			 .buf = readbuf,
			 },
		};
		ret = i2c_transfer(client->adapter, msgs, 2);
		if (ret < 0)
			dev_err(&client->dev, "f%s: i2c read error.\n",
				__func__);
	}
	else 
	{
		struct i2c_msg msgs[] = {
			{
			 .addr = client->addr,
			 .flags = 1,
			 .len = readlen,
			 .buf = readbuf,
			 },
		};
		ret = i2c_transfer(client->adapter, msgs, 1);
		
		if (ret < 0)
			dev_err(&client->dev, "%s:i2c read error.\n", __func__);
	}
	
	return ret;
}
/**************************************************************/
int hy46xx_i2c_Write(struct i2c_client *client, char *writebuf, int writelen)
{
	int ret;
	struct i2c_msg msg[] = {
		{
		 .addr = client->addr,
		 .flags = 0,
		 .len = writelen,
		 .buf = writebuf,
		 },
	};
	ret = i2c_transfer(client->adapter, msg, 1);
	if (ret < 0)	
		dev_err(&client->dev, "%s i2c write error.\n", __func__);
	return ret;
}
/**************************************************************/
int hy46xx_write_reg(struct i2c_client * client, unsigned short regaddr, unsigned short regvalue)
{
	unsigned char buf[2] = {0};
	buf[0] = regaddr;
	buf[1] = regvalue;
	
	return hy46xx_i2c_Write(client, buf, sizeof(buf));
}
/************************************************************/
int hy46xx_read_reg(struct i2c_client * client, unsigned char regaddr, unsigned char * regvalue)
{
	return hy46xx_i2c_Read(client, &regaddr, 1, regvalue, 1);
}
/************************************************************/
/*
static int hy46xx_read_BootloaderVer(struct i2c_client* client, unsigned char* Boot_Ver)
{
	unsigned char read_cmd[2]= {0xff,0x90};
	unsigned char cmd_len 	= 2;
	unsigned char data_len = 2;
	if(!i2c_interface_send(client, read_cmd, cmd_len))
	{
		return 0;
	}
	msleep(5);
	if(!i2c_interface_recv(client, Boot_Ver, data_len))
	{
		return 0;
	}
}*/
/************************************************************/
void hy46xx_reset_tp(void)
{
	set the reset_gpio low
	gpio_direction_output(HY46XX_RESET_PIN, 0);
	msleep(10);
	set the reset_gpio hign
	gpio_direction_output(HY46XX_RESET_PIN, 1);
	msleep(5); 
} 
#ifdef HY46XX_FW_UPDATE_ENABLE
/************************************************************/
int  hys_ctpm_fw_upgrade(struct i2c_client * client, unsigned char* pbt_buf, unsigned long dw_lenth, unsigned char lowbyte)
{
	unsigned char 	ret = 0;
	unsigned char 	Data_Buf[2]  = {0};
	unsigned long 	i = 0, j = 0;

	unsigned long 	packet_number 	 = 0;
	unsigned long  	temp = 0, lenght = 0;

	unsigned char 	packet_buf[133] = {0};
	unsigned char   write_flash_enable_cmd[6] = {0xff, 0x63, 0x03, 0x3d, 0x00, 0x00}; 
	unsigned char	Read_checksum_cmd[6] = {0xff,0x62,0x10,0x00,0xef,0x00};
	unsigned char 	arr_erase_flash[2] = {0xff, 0x91};
	unsigned char  	bt_ecc = 0;
	unsigned char   ae_reg = 0xae;
	unsigned char 	boot_ver_cmd[2] = {0xff, 0x90};
	packet_number = (dw_lenth) / HYS_PACKET_LENGTH;
	
	packet_buf[0] = 0xbf;
	lenght = HYS_PACKET_LENGTH;
	packet_buf[3] = (unsigned char)(lenght >> 8);
	packet_buf[4] = (unsigned char)lenght;
	printk("STEP 1 : RESET TP \n");
	hy46xx_reset_tp();
	msleep(30);
	
	printk("STEP 2 : Read Bootloader version \n");
	ret = i2c_interface_send(client, boot_ver_cmd, 2); 
	ret = i2c_interface_recv(client, Data_Buf, 2);  
	printk("read back: reg_val[0]=0x%x, reg_val[1]=0x%x\n", Data_Buf[0], Data_Buf[1]);	
	
	printk("STEP 3 : Write Flash Enable \n");	
	for(i=0;i<10;i++)
	{
		hy46xx_i2c_Write(client, write_flash_enable_cmd, 6);
		msleep(10);
		i2c_interface_recv(client, Data_Buf, 1);
		printk(" Write Flash Enable value = 0x%x\n", Data_Buf[0]);
		if(Data_Buf[0] == 0x3d)
		{	printk("Write Flash Enable success \n");
			break;
		}
	}	
	if(Data_Buf[0] != 0x3d)
	{
		printk("Update firmware fail in step 3 \n");
		return;
	}
	printk("STEP 4 : Erase Flash \n");
	i2c_interface_send(client, arr_erase_flash, 2);
	msleep(1500);
	printk("STEP 5 : Write Flash \n");
	for (j = 0;j < packet_number; j++) 
	{
		temp = j * HYS_PACKET_LENGTH; 
		packet_buf[1] = (unsigned char)(temp >> 8);  
		packet_buf[2] = (unsigned char)temp;    		
		for (i = 0;i < HYS_PACKET_LENGTH; i++)
		{
		    packet_buf[5 + i] = pbt_buf[j * HYS_PACKET_LENGTH + i]; 		    
		} 				
		ret = i2c_interface_send(client, packet_buf, 133);
		if(ret >= 0)
			printk("wri_in pack_buf is 133: ret=%d , %d\n", ret,j);
		msleep(30);
	}
	printk("STEP 6 : Read Checksum \n");
	ret = i2c_interface_send(client, Read_checksum_cmd, 6);
	msleep(200);
	ret = i2c_interface_recv(client, Data_Buf, 1);
	if((Data_Buf[0] != lowbyte)&&(lowbyte !=0))
	{
		printk("correct ecc is: 0x%x\n", lowbyte);
		printk("ecc return: reg_val[0]=0x%x\n", Data_Buf[0]);	
		printk("ECC fail , Update firmware fail in step 6 \n");
		return -1;
	}
	else
		printk("STEP 7 : Update firmware success ,Reset TP \n");
	
	hy46xx_reset_tp();
	msleep(1000);	
	return 1;	
}
/************************************************************/
unsigned char hys_ctpm_get_i_file_ver(void)
{
    unsigned short ui_sz;
    ui_sz = sizeof(CTPM_FW);
    return CTPM_FW[ui_sz - 1];
}
/************************************************************/
/************************************************************/
/***DAVE 20240321*/
int hys_ctpm_fw_upgrade_with_i_file(struct i2c_client * client)
{
	unsigned char * pbt_buf = NULL;
	int ret;
	int i_ret = -1;
	
	int i;
	
	unsigned char IC_FW_Version;
	unsigned char IC_FW_Checksum;
	unsigned char I_File_Version;
	unsigned char i_checksum = 0;
	
	unsigned char Data_Buf[2]  = {0,0};
	
	unsigned char Read_checksum_cmd[6] = {0xff,0x62,0x10,0x00,0xef,0x00};
	unsigned char Read_IC_FW_Version_cmd[5]={0xff,0x03,0xfe,0x78,0x08};
	
	unsigned int fw_len = sizeof(CTPM_FW);
	
	for(i=0;i<fw_len;i++)
	{
		i_checksum += CTPM_FW[i];
	}
	
	pbt_buf = CTPM_FW;
	
	hy46xx_reset_tp();
	msleep(45);
	ret = i2c_interface_send(client, Read_checksum_cmd, 6);
	msleep(200);
	ret = i2c_interface_recv(client, Data_Buf, 1);
	IC_FW_Checksum = Data_Buf[0];
	ret = i2c_interface_send(client, Read_IC_FW_Version_cmd, 5);
	msleep(30);
	ret = i2c_interface_recv(client, Data_Buf, 1);
	IC_FW_Version=Data_Buf[0];
	
	I_File_Version = hys_ctpm_get_i_file_ver();
	
	printk("IC FW CheckSum Code is: 0x%x\n", IC_FW_Checksum);
	printk("IC FW Version is: 0x%x\n", IC_FW_Version);
	printk("i File CheckSum Code is: 0x%x\n", i_checksum);
	printk("I File Versionis: 0x%x\n", I_File_Version);
	
	if((IC_FW_Checksum != i_checksum)||(IC_FW_Version !=I_File_Version))
	{	
		printk("Star updata CTP FW \n");
		do
		{
			i_ret = hys_ctpm_fw_upgrade(client, pbt_buf, sizeof(CTPM_FW), i_checksum);	
		}
		while(i_ret<0);
	}
	else
	{	
		printk("IC FW version, check code and i file the same ,Reset TP \n");
		hy46xx_reset_tp();
		msleep(1000);
	}					
	return i_ret;
}
#endif 

/**************************************************************/
static int hy46xx_read_Touchdata(struct hy46xx_ts_data *data)
{
	struct ts_event *event = &data->event;
	unsigned char  buf[POINT_READ_BUF] = { 0 };
	int ret = -1;
	int i = 0;
	unsigned char pointid = HY_MAX_ID;
	unsigned char iic_buff_checksum = 0;
	unsigned char iic_checksum;
	for(i = 0; i < POINT_READ_BUF; i++)
	{
		buf[i] = 0xff;
	}
	memset(event, 0, sizeof(struct ts_event));
	buf[0] = 0;
	ret = hy46xx_i2c_Read(data->client, buf, 1, buf, POINT_READ_BUF);
	if (ret < 0) {
		dev_err(&data->client->dev, "%s read touchdata failed.\n",
			__func__);
		return ret;
	}
	#if 1
	for(i = 0; i < POINT_READ_BUF; i++)
	{
		pr_info("buf[%d]= 0x%x\n", i,buf[i]);
	}
	#endif
	
#ifdef IIC_BUFF_CHECK_ENABLE	/***DAVE 20231122*/
	iic_checksum = buf[1];
	for(i = 0;i<buf[7];i++)
	{
		iic_buff_checksum = iic_buff_checksum + buf[i+2];
	}
	if(iic_checksum == iic_buff_checksum)
	{
		pr_info("IIC BUFF Check PASS!\n");
	}
	else
	{
		pr_info("IIC BUFF Check failed!\n");
		pr_info("iic_checksum = %d,iic_buff_checksum = %d\n", iic_checksum,iic_buff_checksum);
		return -1;
	}
#endif
	event->touch_point = 0;
	for (i = 0; i < CFG_MAX_TOUCH_POINTS; i++) {
		pointid = (buf[HY_TOUCH_ID_POS + HY_TOUCH_STEP * i]) >> 4;
		if (pointid >= HY_MAX_ID)
			break;
		else{
			event->touch_point++;
			event->au16_x[i] =(unsigned short) (buf[HY_TOUCH_X_H_POS + HY_TOUCH_STEP * i] & 0x0F) << 8 | (s16) buf[HY_TOUCH_X_L_POS + HY_TOUCH_STEP * i];
			event->au16_y[i] =(unsigned short) (buf[HY_TOUCH_Y_H_POS + HY_TOUCH_STEP * i] & 0x0F) <<8 | (s16) buf[HY_TOUCH_Y_L_POS + HY_TOUCH_STEP * i];
			event->au8_touch_event[i] =buf[HY_TOUCH_EVENT_POS + HY_TOUCH_STEP * i] >> 6;
			event->au8_finger_id[i] =(buf[HY_TOUCH_ID_POS + HY_TOUCH_STEP * i]) >> 4;
			}
		#if 1
		pr_info("id=%d event=%d x=%d y=%d\n", event->au8_finger_id[i],event->au8_touch_event[i], event->au16_x[i], event->au16_y[i]);
		//printk("id=%d event=%d x=%d y=%d\n", event->au8_finger_id[i],event->au8_touch_event[i], event->au16_x[i], event->au16_y[i]);
		#endif
	}

	event->pressure = 255;

	return 0;
}
/**************************************************************/
static void hy46xx_report_value(struct hy46xx_ts_data *data)
{
	struct ts_event *event = &data->event;
	int i;
	int uppoint = 0;
	for (i = 0; i < event->touch_point; i++)
	{
		if((event->au16_x[i] < RESOLUTION_X) && (event->au16_y[i] < RESOLUTION_Y))
		{
			input_mt_slot(data->input_dev, event->au8_finger_id[i]);			
			if (event->au8_touch_event[i]== 0 || event->au8_touch_event[i] == 2)
			{								
				input_mt_report_slot_state(data->input_dev, MT_TOOL_FINGER,true);
				input_report_abs(data->input_dev, ABS_MT_TOUCH_MAJOR,event->pressure);
				input_report_abs(data->input_dev, ABS_MT_POSITION_X,event->au16_x[i]);
				input_report_abs(data->input_dev, ABS_MT_POSITION_Y,event->au16_y[i]);					
			}
			else
			{
				uppoint++;
				input_mt_report_slot_state(data->input_dev, MT_TOOL_FINGER,false);
			}
			
		}
		else
		{
			input_mt_slot(data->input_dev, event->au8_finger_id[i]);
			input_mt_report_slot_state(data->input_dev, MT_TOOL_FINGER,false);
		}
		
#ifdef LINUX_OS
		input_mt_sync(data->input_dev);
#endif
	}
	if(event->touch_point == uppoint)
		input_report_key(data->input_dev, BTN_TOUCH, 0);
	else
		input_report_key(data->input_dev, BTN_TOUCH, 1);
	input_sync(data->input_dev);

}
/**************************************************************/
static irqreturn_t hy46xx_ts_interrupt(int irq, void *dev_id)
{
	struct hy46xx_ts_data *hy46xx_ts = dev_id;
	//int ret = 0;
	disable_irq_nosync(hy46xx_ts->irq);
	hy46xx_read_Touchdata(hy46xx_ts);
	hy46xx_report_value(hy46xx_ts);
	enable_irq(hy46xx_ts->irq);
	return IRQ_HANDLED;
}
/**********************************************************************************/
static int hy46xx_ts_probe(struct i2c_client *client,const struct i2c_device_id *id)
{
	//struct hy46xx_platform_data *pdata = (struct hy46xx_platform_data *)client->dev.platform_data;
	struct hy46xx_platform_data *pdata;
	struct hy46xx_ts_data *hy46xx_ts;
	struct input_dev *input_dev;
	int err = 0;
	unsigned char IC_FW_Verson;
	//unsigned char I_File_Version;
	unsigned char uc_reg_addr;

	if (!i2c_check_functionality(client->adapter, I2C_FUNC_I2C)) {
		err = -ENODEV;
		goto exit_check_functionality_failed;
	}

	pdata = kzalloc(sizeof(struct hy46xx_platform_data), GFP_KERNEL);
	if (!pdata) {
		err = -ENOMEM;
		goto exit_alloc_data_failed;
	}

	hy46xx_ts = kzalloc(sizeof(struct hy46xx_ts_data), GFP_KERNEL);

	if (!hy46xx_ts) {
		err = -ENOMEM;
		goto exit_alloc_data_failed;
	}

	i2c_set_clientdata(client, hy46xx_ts);

	if (pdata == NULL) {
		printk(KERN_ERR"============> pdata is null\n");
	}
	printk(KERN_ERR"============> pdata is not null\n");

	pdata->x_max = RESOLUTION_X;
	pdata->y_max = RESOLUTION_Y;
	//hy46xx_ts->irq = IRQ_EINT(14);
	hy46xx_ts->irq = gpio_to_irq(HY46XX_IRQ_PIN);	
	hy46xx_ts->client = client;
	hy46xx_ts->pdata = pdata;
	hy46xx_ts->x_max = pdata->x_max - 1;
	hy46xx_ts->y_max = pdata->y_max - 1;
	hy46xx_ts->pdata->reset = HY46XX_RESET_PIN;
	hy46xx_ts->pdata->irq = hy46xx_ts->irq;
	client->irq = hy46xx_ts->irq;
	pr_info("irq = %d\n", client->irq);
	pr_info("irq = %d\n", client->irq);
	
	err = request_threaded_irq(client->irq, NULL, hy46xx_ts_interrupt,IRQF_TRIGGER_FALLING | IRQF_ONESHOT, client->dev.driver->name,hy46xx_ts);
	if (err < 0) {
		dev_err(&client->dev, "hy46xx_probe: request irq failed\n");
		goto exit_irq_request_failed;
	}
	disable_irq(client->irq);

	input_dev = input_allocate_device();
	if (!input_dev) {
		err = -ENOMEM;
		dev_err(&client->dev, "failed to allocate input device\n");
		goto exit_input_dev_alloc_failed;
	}

	hy46xx_ts->input_dev = input_dev;

	__set_bit(EV_ABS, input_dev->evbit);
	__set_bit(EV_KEY, input_dev->evbit);
	__set_bit(BTN_TOUCH, input_dev->keybit);
	
	//set_bit(ABS_MT_POSITION_X, ts->input_dev->absbit);
	//set_bit(ABS_MT_POSITION_Y, ts->input_dev->absbit);

	////input_mt_init_slots(input_dev, 10);
	//input_mt_init_slots(input_dev, 11, 0);
	//input_mt_init_slots(input_dev, CFG_MAX_TOUCH_POINTS);
	input_mt_init_slots(input_dev, 5, 2);
	input_set_abs_params(input_dev, ABS_MT_TOUCH_MAJOR, 0, 0XFF, 0, 0);
	input_set_abs_params(input_dev, ABS_MT_POSITION_X,  0, (RESOLUTION_X-1), 0, 0);
	input_set_abs_params(input_dev, ABS_MT_POSITION_Y,  0, (RESOLUTION_Y-1), 0, 0);

	input_dev->name = HY46XX_NAME;
	err = input_register_device(input_dev);
	if (err) {
		dev_err(&client->dev,
			"hy46xx_ts_probe: failed to register input device: %s\n",
			dev_name(&client->dev));
		goto exit_input_register_device_failed;
	}	


	hy46xx_reset_tp();
	msleep(2000);
	/*get firmware version */
	uc_reg_addr = HY46XX_REG_FW_VER;
	hy46xx_i2c_Read(client, &uc_reg_addr, 1, &IC_FW_Verson, 1);
	pr_info( "[HYS] Firmware version = 0x%x\n", IC_FW_Verson);

#ifdef HY46XX_FW_UPDATE_ENABLE
	hys_ctpm_fw_upgrade_with_i_file(client);
#endif

	enable_irq(client->irq);
	return 0;

exit_input_register_device_failed:
	input_free_device(input_dev);

exit_input_dev_alloc_failed:
	free_irq(client->irq, hy46xx_ts);

//exit_init_gpio:
//	hys_un_init_gpio_hw(hy46xx_ts);

exit_irq_request_failed:
	i2c_set_clientdata(client, NULL);
	kfree(hy46xx_ts);

exit_alloc_data_failed:
exit_check_functionality_failed:
	return err;
}
static const struct i2c_device_id hy46xx_ts_id[] = {
	{HY46XX_NAME, 0},
	{}
};
static const struct of_device_id hy46xx_dt_match[] = {
	{.compatible = "hycon,hy46xx_ts"},
	{},
};
MODULE_DEVICE_TABLE(of, hy46xx_dt_match);
//MODULE_DEVICE_TABLE(i2c, hy46xx_ts_id);

/************************************************************/
static int hy46xx_ts_remove(struct i2c_client *client)
{
	struct hy46xx_ts_data *hy46xx_ts;
	hy46xx_ts = i2c_get_clientdata(client);
	input_unregister_device(hy46xx_ts->input_dev);

	#ifdef HYS_APK_DEBUG
		hy46xx_remove_sysfs(client);
		hy_rw_iic_drv_exit();
		hy46xx_release_apk_debug_channel();
	#endif

	free_irq(client->irq, hy46xx_ts);

	kfree(hy46xx_ts);
	i2c_set_clientdata(client, NULL);
	return 0;
}
static struct i2c_driver hy46xx_ts_driver = {
	.probe = hy46xx_ts_probe,
	.remove = hy46xx_ts_remove,
	.id_table = hy46xx_ts_id,
	//.suspend = hy46xx_ts_suspend,
	//.resume = hy46xx_ts_resume,
	.driver = {
		   .name = HY46XX_NAME,
		   .owner = THIS_MODULE,
		   .of_match_table = hy46xx_dt_match,
		   },
};
/************************************************************/
static int __init hy46xx_ts_init(void)
{
	int ret;
	ret = i2c_add_driver(&hy46xx_ts_driver);
	if (ret) {
		printk(KERN_WARNING "Adding hy46xx driver failed "
		       "(errno = %d)\n", ret);
	} else {
		pr_info("Successfully added driver %s\n",
			hy46xx_ts_driver.driver.name);
	}
	return ret;
}
/************************************************************/
static void __exit hy46xx_ts_exit(void)
{
	i2c_del_driver(&hy46xx_ts_driver);
}

module_init(hy46xx_ts_init);
module_exit(hy46xx_ts_exit);

MODULE_AUTHOR("<tp term>");
MODULE_DESCRIPTION("HYCON hy46xx TouchScreen driver");
MODULE_LICENSE("GPL");
